/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.easymagic.mixin;

import com.fuzs.easymagic.EasyMagic;
import com.fuzs.easymagic.inventory.container.EnchantmentInventoryContainer;
import com.fuzs.easymagic.tileentity.EnchantingTableInventoryTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.EnchantingTableBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantingTableBlock.class})
public abstract class EnchantingTableBlockMixin
extends ContainerBlock {
    protected EnchantingTableBlockMixin(AbstractBlock.Properties builder) {
        super(builder);
    }

    @Inject(method={"createNewTileEntity"}, at={@At(value="HEAD")}, cancellable=true)
    public void createNewTileEntity(IBlockReader worldIn, CallbackInfoReturnable<TileEntity> callbackInfo) {
        if (EasyMagic.EASY_ENCHANTING.isEnabled()) {
            callbackInfo.setReturnValue((Object)new EnchantingTableInventoryTileEntity());
        }
    }

    @Inject(method={"onBlockActivated"}, at={@At(value="HEAD")}, cancellable=true)
    public void onBlockActivated(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit, CallbackInfoReturnable<ActionResultType> callbackInfo) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (!worldIn.field_72995_K && tileentity instanceof EnchantingTableInventoryTileEntity) {
            player.func_213829_a((INamedContainerProvider)tileentity);
            callbackInfo.setReturnValue((Object)ActionResultType.CONSUME);
        }
    }

    @Redirect(method={"animateTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;isAirBlock(Lnet/minecraft/util/math/BlockPos;)Z"))
    private boolean isBlockEmpty(World world, BlockPos pos) {
        return EnchantmentInventoryContainer.isBlockEmpty(world, pos);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (!state.func_203425_a(newState.func_177230_c()) && tileentity instanceof EnchantingTableInventoryTileEntity) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tileentity));
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof IInventory) {
            ItemStack catalystItem = ((IInventory)tileentity).func_70301_a(1);
            return Math.min(catalystItem.func_190916_E(), 3);
        }
        return 0;
    }
}

